#include "DaneOCT.h"

#include <stdio.h>
#include <windows.h>
#include <math.h>
#include <gl\gl.h>

const double log2_10=3.3219280948873623478703194294894;

void Kostka3D::WczytajDane(char* nazwaPliku)
{
	FILE *plik;

	Wczytaj = false;
	plik = fopen(nazwaPliku, "rb");
	if (!plik) MessageBox(NULL,"Bd otwarcia pliku!","",NULL);
		else{
			fread(&szer, sizeof(int),1, plik);
			fread(&wys, sizeof(int),1, plik);
			fread(&glebokosc, sizeof(int),1, plik);
			szer2n = UstalWymiar2doN(szer);
			wys2n = UstalWymiar2doN(wys);
			glebokosc2n = UstalWymiar2doN(glebokosc);
			wszystkieElementy = szer*wys*glebokosc;
			kostka = new char[wszystkieElementy];
			fread(kostka, 1,wszystkieElementy, plik);
			fclose(plik);
			wczytajDefinicjeKolorow();
			inicjuj();
		};
}

Kostka3D::~Kostka3D()
{
	if (kostka!=NULL) {
		delete[] kostka;
		kostka = NULL;
	}
}

int Kostka3D::UstalWymiar2doN(int a)
{
   if (a<=64) return 64;
   return (int)pow(2,ceil(log10((float)a)*log2_10));
}

void Kostka3D::wczytajDefinicjeKolorow()
{
	FILE *plik;
	plik = fopen("def.bin", "rb");
	if (plik){
		for(int j = 0; j < 255; j++)
			fread(&defKol[j],1,3,plik);
			//wczytaj dane do dwuwymiarowej tablicy do wiersza [j] 
			//wartoci jednobajtowe, 3 elementy
		fclose(plik);
	}
}

void Kostka3D::zmienMapyKolorow()
{
	int i,j=parJasn+parKontr,przedzial;
	int poczatek,koniec;

	koniec = parJasn-(parKontr/2);

	for (i = 0; i < koniec; i++) if(i<256){
		szaroscMAPA[i] = 0;
		kolorMAPA[i][0]=0;
		kolorMAPA[i][1]=0;
		kolorMAPA[i][2]=0;
	}     //czarny kolor dla szumw

	poczatek = koniec;
	koniec = parJasn+(parKontr/2);
	przedzial = koniec-poczatek;

	for (i = poczatek; i < koniec; i++) if(i<256){
		szaroscMAPA[i] = (unsigned char)((255*((float)i-poczatek))/przedzial);
		kolorMAPA[i][0]=defKol[szaroscMAPA[i]][0];
		kolorMAPA[i][1]=defKol[szaroscMAPA[i]][1];
		kolorMAPA[i][2]=defKol[szaroscMAPA[i]][2];
	}

	for (i = koniec; i < 256; i++) {
		szaroscMAPA[i] = 255;
		kolorMAPA[i][0]=255;
		kolorMAPA[i][1]=255;
		kolorMAPA[i][2]=255;
	}   // bialy kolor poza skalami
}

void Kostka3D::inicjuj()
{
	iloscBskanowDoWysw = 80;
	iloscPrzekrojowDoWysw = 80;
	iloscPrzekrojowPozDoWysw = 80;
	kolor = false;

	parJasn = 150;
	parKontr= 60;
	parPrzezroczystosci = 5;
	zmienMapyKolorow();
	WczytajTekstury();
}

void Kostka3D::RysujPrzekroje()
{
	int i;
	float z,y,x,obszarB,obszarP,obszarPPoz;

	obszarB = (float)glebokosc/glebokosc2n;
	obszarP = (float)szer/szer2n;
	obszarPPoz = (float)wys/wys2n;

	glEnable(GL_TEXTURE_2D);

	glColor4f(1.0f,1.0f,1.0f,parPrzezroczystosci/100);			//  15% przeroczystoci

	//ustawienia mieszania kolorow
	glEnable(GL_BLEND);         // wczenie przeroczystoci
	glDisable(GL_DEPTH_TEST);   // wycznie bufora Z
	glBlendFunc(GL_SRC_ALPHA,GL_ONE); //okrelenie sposobu mieszania kolorw: 
										//mieszanie sumujace

	for(i=0;i<iloscBskanowDoWysw;i++){
		glBindTexture(GL_TEXTURE_2D, teksturyB[i]);
		z = (((float)i*2)/iloscBskanowDoWysw - 1)*obszarB;
			glNormal3f( 0.0f, 0.0f, 1.0f);
		glBegin(GL_QUADS);
			glTexCoord2f(1.0f, 1.0f);
			glVertex3f(-1.0f, -1.0f, z);
			glTexCoord2f(0.0f, 1.0f);
			glVertex3f( 1.0f, -1.0f, z);
			glTexCoord2f(0.0f, 0.0f);
			glVertex3f( 1.0f,  1.0f, z);
			glTexCoord2f(1.0f, 0.0f);
			glVertex3f(-1.0f,  1.0f, z);
		glEnd();
	}

	for(i=0;i<iloscPrzekrojowDoWysw;i++){
		glBindTexture(GL_TEXTURE_2D, teksturyP[i]);
		x = (((float)i*2)/iloscPrzekrojowDoWysw - 1)*obszarP;
			glNormal3f( 1.0f, 0.0f, 0.0f);
		glBegin(GL_QUADS);
			glTexCoord2f(1.0f, 1.0f);
			glVertex3f( -x, -1.0f,  1.0f);
			glTexCoord2f(0.0f, 1.0f);
			glVertex3f( -x, -1.0f,  -1.0f);
			glTexCoord2f(0.0f, 0.0f);
			glVertex3f( -x,  1.0f,  -1.0f);
			glTexCoord2f(1.0f, 0.0f);
			glVertex3f( -x,  1.0f,   1.0f);
		glEnd();
	}

	for(i=0;i<iloscPrzekrojowPozDoWysw;i++){
		glBindTexture(GL_TEXTURE_2D, teksturyPPoz[i]);
		y = (((float)i*2)/iloscPrzekrojowPozDoWysw - 1)*obszarPPoz;
			glNormal3f( 0.0f, 1.0f, 0.0f);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 1.0f);
			glVertex3f( 1.0f, -y,  1.0f);
			glTexCoord2f(1.0f, 1.0f);
			glVertex3f( -1.0f, -y,  1.0f);
			glTexCoord2f(1.0f, 0.0f);
			glVertex3f( -1.0f,  -y,  -1.0f);
			glTexCoord2f(0.0f, 0.0f);
			glVertex3f( 1.0f,  -y,   -1.0f);
		glEnd();
	 }

}

void Kostka3D::TworzTekstureBSkan(int uchwytDoTekstury, int nrBSkanuDoWysw)
{
	GLubyte* bits=NULL;
	int minx,miny,maxx,maxy,klatka;
	
	if (!kolor) //tekstura w skali szaroci
	{
		if (bits==NULL) bits = new GLubyte[szer2n*wys2n];
												//przydzielenie pamici dla bufora tekstury
		klatka = (szer*wys*nrBSkanuDoWysw); //ustala o ile bajtw dalej czyta
											//z tablicy, aby czyta kolejna klatk (B-skan)
		
		minx = (szer2n-szer)/2; //zmienne zmniejszajce ilo dodawa w ptli
		miny = (wys2n-wys)/2;
		maxx = minx+szer;
		maxy = miny+wys;
		
		for(int x = 0; x < szer2n; x++) //przekazanie waciwych danych z "kostki" do bufora
			for(int y = 0; y < wys2n; y++)
				if ((x>minx)&&(x<maxx)&&(y>miny)&&(y<maxy))
					*(bits+(x+szer2n*y)) =
					 szaroscMAPA[(GLubyte)*(kostka+y-miny+wys*(x-minx)+klatka)];
				else
					*(bits+(x+szer2n*y))= 0;	// ramka

		glBindTexture(GL_TEXTURE_2D, uchwytDoTekstury);
		glTexImage2D(GL_TEXTURE_2D, 0, 1, szer2n, wys2n, 0, GL_LUMINANCE,
													GL_UNSIGNED_BYTE, bits);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		
		if (bits!=NULL) {		//zwolnienie tymczasowej pamieci (bufora), przez ktr 
			delete[] bits;		//przekazana zostaa tekstura
			bits = NULL;
		}	
	}
	else //tekstura kolorowa
	{ 
		if (bits==NULL) bits = new GLubyte[szer2n*wys2n*3];

		klatka = (szer*wys*nrBSkanuDoWysw);   //ustala o ile bajtw dalej czytac
										//z tablicy  aby czytac kolejna klatke (BSkan)

		minx = (szer2n-szer)/2;	//zmienne zminiejszajace ilosc dodawan w petli
		miny = (wys2n-wys)/2;
		maxx = minx+szer;
		maxy = miny+wys;

		for(int x = 0; x < szer2n; x++)
			for(int y = 0; y < wys2n; y++)
			{
				if ((x>minx)&&(x<maxx)&&(y>miny)&&(y<maxy)){
					*(bits+3*(x+szer2n*y)) = (GLubyte)
						kolorMAPA[(unsigned char) *(kostka+y-miny+wys*(x-minx)+klatka)][0];
					*(bits+3*(x+szer2n*y)+1) = (GLubyte)
						kolorMAPA[(unsigned char) *(kostka+y-miny+wys*(x-minx)+klatka)][1];
					*(bits+3*(x+szer2n*y)+2) = (GLubyte) 
						kolorMAPA[(unsigned char) *(kostka+y-miny+wys*(x-minx)+klatka)][2];
				}else{
					*(bits+3*(x+szer2n*y))= 0;		//ramka
					*(bits+3*(x+szer2n*y)+1) =0;
					*(bits+3*(x+szer2n*y)+2) =0;
					}
			}
			glBindTexture(GL_TEXTURE_2D, uchwytDoTekstury);
			glTexImage2D(GL_TEXTURE_2D, 0, 3, szer2n, wys2n, 0, GL_RGB,
														GL_UNSIGNED_BYTE, bits);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			if (bits!=NULL) {
				delete[] bits;
				bits = NULL;
			}
	}
	return;
}

void Kostka3D::TworzTeksturePrzekPop(int uchwytDoTekstury, int nrPrzekrojuDoWysw)
{
	GLubyte* bits=NULL;
	int minx,miny,maxx,maxy,klatka;
	
	if (!kolor) //tekstura w skali szaroci
	{
		if (bits==NULL) bits = new GLubyte[glebokosc2n*wys2n];
		
		klatka = (wys*szer); //rozmiar klatki w tablicy kostka
		
		minx = (glebokosc2n-glebokosc)/2;
		miny = (wys2n-wys)/2;
		maxx = minx+glebokosc;
		maxy = miny+wys;
		
		for(int x = 0; x < glebokosc2n; x++)
			for(int y = 0; y < wys2n; y++)
				if ((x>minx)&&(x<maxx)&&(y>miny)&&(y<maxy))
				*(bits+x+glebokosc2n*y) = szaroscMAPA[(GLubyte)*(kostka+y-miny+klatka*(x-minx)+nrPrzekrojuDoWysw*wys)];
			else
				*(bits+x+glebokosc2n*y) = 0; //ramka
		glBindTexture(GL_TEXTURE_2D, uchwytDoTekstury);
		glTexImage2D(GL_TEXTURE_2D, 0, 1, glebokosc2n, wys2n, 0, GL_LUMINANCE,GL_UNSIGNED_BYTE, bits);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		
		if (bits!=NULL) 
		{
			delete[] bits;
			bits = NULL;
		}
	}
	else //tekstura kolorowa
	{
	if (bits==NULL) bits = new GLubyte[glebokosc2n*wys2n*3];
	
	klatka = (wys*szer); //rozmiar klatki (B-skanu) w tablicy kostka
	
	minx = (glebokosc2n-glebokosc)/2;
	miny = (wys2n-wys)/2;
	maxx = minx+glebokosc;
	maxy = miny+wys;
	
	for(int x = 0; x < glebokosc2n; x++)
		for(int y = 0; y < wys2n; y++)
		{
			if ((x>minx)&&(x<maxx)&&(y>miny)&&(y<maxy))
			{
				*(bits+3*(x+glebokosc2n*y)) = (GLubyte)
					kolorMAPA[(unsigned char) *(kostka+y-miny+klatka*(x-minx)+nrPrzekrojuDoWysw*wys)][0];
				*(bits+3*(x+glebokosc2n*y)+1) = (GLubyte)
					kolorMAPA[(unsigned char) *(kostka+y-miny+klatka*(x-minx)+nrPrzekrojuDoWysw*wys)][1];
				*(bits+3*(x+glebokosc2n*y)+2) =  (GLubyte)
					kolorMAPA[(unsigned char) *(kostka+y-miny+klatka*(x-minx)+nrPrzekrojuDoWysw*wys)][2];
			}else{
				*(bits+3*(x+glebokosc2n*y)) = 0;		//ramka
				*(bits+3*(x+glebokosc2n*y)+1) = 0;
				*(bits+3*(x+glebokosc2n*y)+2) = 0;
			}
			}
		glBindTexture(GL_TEXTURE_2D, uchwytDoTekstury);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, glebokosc2n, wys2n, 0, GL_RGB,GL_UNSIGNED_BYTE, bits);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		
		if (bits!=NULL) 
		{
			delete[] bits;
			bits = NULL;
		}
	}
	return;
}

void Kostka3D::TworzTeksturePrzekPoz(int uchwytDoTekstury, int nrPrzekrojuPozDoWysw)
{
	GLubyte* bits=NULL;
	int minx,miny,maxx,maxy,klatka;
	if (!kolor) //tekstura w skali szaroci
	{
		if (bits==NULL) bits = new GLubyte[szer2n*wys2n];
		klatka = (szer*wys); //ustala o ile bajtw dalej czyta
							//z tablicy, aby czyta kolejn klatk (B-skan)
		
		minx = (szer2n-szer)/2; //zmienne zmniejszajce ilo dodawa w ptli
		miny = (glebokosc2n-glebokosc)/2;
		maxx = minx+szer;
		maxy = miny+glebokosc;
		
		for(int x = 0; x < szer2n; x++) //przekazanie waciwych danych z "kostki" do bufora
			for(int y = 0; y < glebokosc2n; y++)
				if ((x>minx)&&(x<maxx)&&(y>miny)&&(y<maxy))
					*(bits+(x+szer2n*y)) =
					szaroscMAPA[(GLubyte)*(kostka+nrPrzekrojuPozDoWysw+(y-miny)*klatka+wys*(x-minx))];
				else
					*(bits+(x+szer2n*y))= 0; //ramka
		glBindTexture(GL_TEXTURE_2D, uchwytDoTekstury);
		glTexImage2D(GL_TEXTURE_2D, 0, 1, szer2n, wys2n, 0, GL_LUMINANCE,
													GL_UNSIGNED_BYTE, bits);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		
		if (bits!=NULL) //zwolnienie tymczasowej pamici (bufora), przez ktr przekazana zostaa tekstura
		{
			delete[] bits;
			bits = NULL;
		}
	}
	else //tekstura kolorowa
	{
		if (bits==NULL) bits = new GLubyte[szer2n*wys2n*3];
		
		klatka = (szer*wys); //ustala o ile bajtw dalej czyta z tablicy, aby czyta kolejn klatk (B-skan)

		minx = (szer2n-szer)/2; //zmienne zmniejszajce ilo dodawa w ptli
		miny = (glebokosc2n-glebokosc)/2;
		maxx = minx+szer;
		maxy = miny+glebokosc;

		for(int x = 0; x < szer2n; x++) //przekazanie waciwych danych z "kostki" do bufora
			for(int y = 0; y < glebokosc2n; y++)
			{
				if ((x>minx)&&(x<maxx)&&(y>miny)&&(y<maxy)){
					*(bits+3*(x+szer2n*y)) = (GLubyte)
						kolorMAPA[(unsigned char) *(kostka+nrPrzekrojuPozDoWysw+
													(y-miny)*klatka+wys*(x-minx))][0];
					*(bits+3*(x+szer2n*y)+1) = (GLubyte)
						kolorMAPA[(unsigned char) *(kostka+nrPrzekrojuPozDoWysw+
													(y-miny)*klatka+wys*(x-minx))][1];
					*(bits+3*(x+szer2n*y)+2) = (GLubyte)
						kolorMAPA[(unsigned char) *(kostka+nrPrzekrojuPozDoWysw+
													(y-miny)*klatka+wys*(x-minx))][2];
				}
				else
				{
					*(bits+3*(x+szer2n*y))= 0; //ramka
					*(bits+3*(x+szer2n*y)+1) =0;
					*(bits+3*(x+szer2n*y)+2) =0;
				}
			}
			glBindTexture(GL_TEXTURE_2D, uchwytDoTekstury);
			glTexImage2D(GL_TEXTURE_2D, 0, 3, szer2n, wys2n, 0, GL_RGB,
												GL_UNSIGNED_BYTE, bits);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			
			if (bits!=NULL) 
			{
				delete[] bits;
				bits = NULL;
			}
		}
		return;
}

void Kostka3D::WczytajTekstury()
{
	int i, nrBskanuDoWysw,nrPrzekDoWysw,nrPrzekPozDoWysw;
	
	float wsp=(float)glebokosc/iloscBskanowDoWysw;
	
	for(i=0;i<iloscBskanowDoWysw;i++){
		if (!glIsTexture(teksturyB[i]))
			glGenTextures(1, &teksturyB[i]);
		nrBskanuDoWysw=(int)floor(i*wsp);
		TworzTekstureBSkan(teksturyB[i],nrBskanuDoWysw); //wczytujemy B-skan
	}

	wsp=(float)szer/iloscPrzekrojowDoWysw;
	
	for(i=0;i<iloscPrzekrojowDoWysw;i++){
		if (!glIsTexture(teksturyP[i]))
			glGenTextures(1, &teksturyP[i]);
		nrPrzekDoWysw=(int)floor(i*wsp);
		TworzTeksturePrzekPop(teksturyP[i],nrPrzekDoWysw); //wczytujemy przekrj poprzeczny
	}

	wsp=(float)wys/iloscPrzekrojowPozDoWysw;
	
	for(i=0;i<iloscPrzekrojowPozDoWysw;i++){
		if (!glIsTexture(teksturyPPoz[i]))
			glGenTextures(1, &teksturyPPoz[i]);
		nrPrzekPozDoWysw=(int)floor(i*wsp);
		TworzTeksturePrzekPoz(teksturyPPoz[i],nrPrzekPozDoWysw); //wczytujemy przekrj poziomy
	}
}

void Kostka3D::ZwiekszPrzezroczystosc()
{
	parPrzezroczystosci++;
}

void Kostka3D::ZmniejszPrzezroczystosc()
{
	parPrzezroczystosci--;
}

void Kostka3D::ZwiekszJasnosc()
{
	parJasn--;

	zmienMapyKolorow();
	WczytajTekstury();
}

void Kostka3D::ZmniejszJasnosc()
{
	parJasn++;

	zmienMapyKolorow();
	WczytajTekstury();
}
void Kostka3D::ZwiekszKontrast()
{
	parKontr--;

	zmienMapyKolorow();
	WczytajTekstury();
}
void Kostka3D::ZmniejszKontrast()
{
	parKontr++;

	zmienMapyKolorow();
	WczytajTekstury();
}

void Kostka3D::WlaczKolor()
{
	kolor = true;

	zmienMapyKolorow();
	WczytajTekstury();
}

void Kostka3D::WylaczKolor()
{
	kolor = false;

	zmienMapyKolorow();
	WczytajTekstury();
}